<?php
require_once '../config.php';
requireAdminLogin();

$conn = getDBConnection();
$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'update_header') {
    $logo_text = $_POST['logo_text'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];

    $exists = $conn->query("SELECT id FROM header_settings LIMIT 1")->fetch_assoc();
    if ($exists) {
        $stmt = $conn->prepare("UPDATE header_settings SET logo_text=?, phone=?, email=? WHERE id=?");
        $stmt->bind_param('sssi', $logo_text, $phone, $email, $exists['id']);
        $message = 'Header settings updated.';
    } else {
        $stmt = $conn->prepare("INSERT INTO header_settings (logo_text, phone, email) VALUES (?, ?, ?)");
        $stmt->bind_param('sss', $logo_text, $phone, $email);
        $message = 'Header settings saved.';
    }
    $stmt->execute();
    $stmt->close();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'update_footer') {
    $about_text = $_POST['about_text'];
    $facebook_url = $_POST['facebook_url'];
    $twitter_url = $_POST['twitter_url'];
    $instagram_url = $_POST['instagram_url'];
    $youtube_url = $_POST['youtube_url'];
    $address = $_POST['address'];

    $exists = $conn->query("SELECT id FROM footer_settings LIMIT 1")->fetch_assoc();
    if ($exists) {
        $stmt = $conn->prepare("UPDATE footer_settings SET about_text=?, facebook_url=?, twitter_url=?, instagram_url=?, youtube_url=?, address=? WHERE id=?");
        $stmt->bind_param('ssssssi', $about_text, $facebook_url, $twitter_url, $instagram_url, $youtube_url, $address, $exists['id']);
        $message = 'Footer settings updated.';
    } else {
        $stmt = $conn->prepare("INSERT INTO footer_settings (about_text, facebook_url, twitter_url, instagram_url, youtube_url, address) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('ssssss', $about_text, $facebook_url, $twitter_url, $instagram_url, $youtube_url, $address);
        $message = 'Footer settings saved.';
    }
    $stmt->execute();
    $stmt->close();
}

$header = $conn->query("SELECT * FROM header_settings LIMIT 1")->fetch_assoc();
$footer = $conn->query("SELECT * FROM footer_settings LIMIT 1")->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - CarsDekho Admin</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="page-header">
                <h1>Site Settings</h1>
            </div>

            <?php if ($message): ?>
            <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>

            <div class="settings-sections">
                <section class="settings-card">
                    <h2>Header Settings</h2>
                    <form method="POST" action="">
                        <input type="hidden" name="action" value="update_header">
                        <div class="form-group">
                            <label>Logo Text</label>
                            <input type="text" name="logo_text" class="form-control" value="<?php echo htmlspecialchars($header['logo_text'] ?? ''); ?>">
                        </div>
                        <div class="form-group">
                            <label>Phone</label>
                            <input type="text" name="phone" class="form-control" value="<?php echo htmlspecialchars($header['phone'] ?? ''); ?>">
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="<?php echo htmlspecialchars($header['email'] ?? ''); ?>">
                        </div>
                        <button type="submit" class="btn btn-primary">Save Header</button>
                    </form>
                </section>

                <section class="settings-card">
                    <h2>Footer Settings</h2>
                    <form method="POST" action="">
                        <input type="hidden" name="action" value="update_footer">
                        <div class="form-group">
                            <label>About Text</label>
                            <textarea name="about_text" class="form-control"><?php echo htmlspecialchars($footer['about_text'] ?? ''); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label>Facebook URL</label>
                            <input type="url" name="facebook_url" class="form-control" value="<?php echo htmlspecialchars($footer['facebook_url'] ?? ''); ?>">
                        </div>
                        <div class="form-group">
                            <label>Twitter URL</label>
                            <input type="url" name="twitter_url" class="form-control" value="<?php echo htmlspecialchars($footer['twitter_url'] ?? ''); ?>">
                        </div>
                        <div class="form-group">
                            <label>Instagram URL</label>
                            <input type="url" name="instagram_url" class="form-control" value="<?php echo htmlspecialchars($footer['instagram_url'] ?? ''); ?>">
                        </div>
                        <div class="form-group">
                            <label>YouTube URL</label>
                            <input type="url" name="youtube_url" class="form-control" value="<?php echo htmlspecialchars($footer['youtube_url'] ?? ''); ?>">
                        </div>
                        <div class="form-group">
                            <label>Address</label>
                            <textarea name="address" class="form-control"><?php echo htmlspecialchars($footer['address'] ?? ''); ?></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Save Footer</button>
                    </form>
                </section>
            </div>
        </main>
    </div>
</body>
</html>
<?php $conn->close(); ?>
