<?php
require_once '../config.php';
requireAdminLogin();

$conn = getDBConnection();
$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
    $name = $_POST['name'];
    $brand = $_POST['brand'];
    $image_url = $_POST['image_url'];
    $price_range = $_POST['price_range'];
    $search_count = intval($_POST['search_count']) ?: 0;
    $display_order = $_POST['display_order'] ?: 0;
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    if ($_POST['action'] == 'add') {
        $stmt = $conn->prepare("INSERT INTO most_searched_cars (name, brand, image_url, price_range, search_count, display_order, is_active) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssiii", $name, $brand, $image_url, $price_range, $search_count, $display_order, $is_active);
        $message = 'Most searched car added successfully!';
    } else {
        $id = intval($_POST['id']);
        $stmt = $conn->prepare("UPDATE most_searched_cars SET name=?, brand=?, image_url=?, price_range=?, search_count=?, display_order=?, is_active=? WHERE id=?");
        $stmt->bind_param("ssssiiii", $name, $brand, $image_url, $price_range, $search_count, $display_order, $is_active, $id);
        $message = 'Most searched car updated successfully!';
    }
    $stmt->execute();
    $stmt->close();
}

if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM most_searched_cars WHERE id = $id");
    $message = 'Most searched car deleted successfully!';
}

$cars = $conn->query("SELECT * FROM most_searched_cars ORDER BY display_order ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Most Searched Cars - CarsDekho Admin</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="page-header">
                <h1>Manage Most Searched Cars</h1>
                <button class="btn btn-primary" onclick="openModal()">
                    <i class="fas fa-plus"></i> Add Car
                </button>
            </div>
            
            <?php if ($message): ?>
            <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <div class="admin-table">
                <table>
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Brand</th>
                            <th>Searches</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($car = $cars->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $car['display_order']; ?></td>
                            <td><img src="<?php echo $car['image_url']; ?>" class="table-image"></td>
                            <td><?php echo $car['name']; ?></td>
                            <td><?php echo $car['brand']; ?></td>
                            <td><?php echo $car['search_count']; ?></td>
                            <td>
                                <span class="badge <?php echo $car['is_active'] ? 'badge-success' : 'badge-danger'; ?>">
                                    <?php echo $car['is_active'] ? 'Active' : 'Inactive'; ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info" onclick='editCar(<?php echo json_encode($car); ?>)'>
                                    <i class="fas fa-edit"></i>
                                </button>
                                <a href="?delete=<?php echo $car['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
    
    <div id="carModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2 id="modalTitle">Add Car</h2>
            <form method="POST" action="">
                <input type="hidden" name="action" id="formAction" value="add">
                <input type="hidden" name="id" id="carId">
                
                <div class="form-group">
                    <label>Name *</label>
                    <input type="text" name="name" id="name" required class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Brand *</label>
                    <input type="text" name="brand" id="brand" required class="form-control">
                </div>

                <div class="form-group">
                    <label>Image URL *</label>
                    <input type="url" name="image_url" id="image_url" required class="form-control">
                </div>

                <div class="form-group">
                    <label>Price Range</label>
                    <input type="text" name="price_range" id="price_range" class="form-control">
                </div>

                <div class="form-group">
                    <label>Search Count</label>
                    <input type="number" name="search_count" id="search_count" value="0" class="form-control">
                </div>

                <div class="form-group">
                    <label>Display Order</label>
                    <input type="number" name="display_order" id="display_order" value="0" class="form-control">
                </div>

                <div class="form-group">
                    <label>
                        <input type="checkbox" name="is_active" id="is_active" checked>
                        Active
                    </label>
                </div>

                <button type="submit" class="btn btn-primary">Save</button>
                <button type="button" class="btn btn-secondary" onclick="closeModal()">Cancel</button>
            </form>
        </div>
    </div>
    
    <script>
        function openModal() {
            document.getElementById('carModal').style.display = 'block';
            document.getElementById('modalTitle').textContent = 'Add Car';
            document.getElementById('formAction').value = 'add';
            document.querySelector('form').reset();
        }
        
        function closeModal() {
            document.getElementById('carModal').style.display = 'none';
        }
        
        function editCar(car) {
            document.getElementById('carModal').style.display = 'block';
            document.getElementById('modalTitle').textContent = 'Edit Car';
            document.getElementById('formAction').value = 'edit';
            document.getElementById('carId').value = car.id;
            document.getElementById('name').value = car.name;
            document.getElementById('brand').value = car.brand;
            document.getElementById('image_url').value = car.image_url;
            document.getElementById('price_range').value = car.price_range;
            document.getElementById('search_count').value = car.search_count;
            document.getElementById('display_order').value = car.display_order;
            document.getElementById('is_active').checked = car.is_active == 1;
        }
    </script>
</body>
</html>
<?php $conn->close(); ?>
