<?php
require_once '../config.php';
requireAdminLogin();

$conn = getDBConnection();

$banner_count = $conn->query("SELECT COUNT(*) as count FROM banners WHERE is_active = 1")->fetch_assoc()['count'];
$most_searched_count = $conn->query("SELECT COUNT(*) as count FROM most_searched_cars WHERE is_active = 1")->fetch_assoc()['count'];
$latest_cars_count = $conn->query("SELECT COUNT(*) as count FROM latest_cars WHERE is_active = 1")->fetch_assoc()['count'];

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - CarsDekho</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="page-header">
                <h1>Dashboard</h1>
                <p>Welcome back, <?php echo $_SESSION['admin_username']; ?>!</p>
            </div>
            
            <div class="dashboard-cards">
                <div class="dashboard-card">
                    <div class="card-icon" style="background: #3498db;">
                        <i class="fas fa-image"></i>
                    </div>
                    <div class="card-content">
                        <h3><?php echo $banner_count; ?></h3>
                        <p>Active Banners</p>
                    </div>
                    <a href="banners.php" class="card-link">Manage</a>
                </div>
                
                <div class="dashboard-card">
                    <div class="card-icon" style="background: #e74c3c;">
                        <i class="fas fa-fire"></i>
                    </div>
                    <div class="card-content">
                        <h3><?php echo $most_searched_count; ?></h3>
                        <p>Most Searched Cars</p>
                    </div>
                    <a href="most_searched.php" class="card-link">Manage</a>
                </div>
                
                <div class="dashboard-card">
                    <div class="card-icon" style="background: #2ecc71;">
                        <i class="fas fa-car"></i>
                    </div>
                    <div class="card-content">
                        <h3><?php echo $latest_cars_count; ?></h3>
                        <p>Latest Cars</p>
                    </div>
                    <a href="latest_cars.php" class="card-link">Manage</a>
                </div>
                
                <div class="dashboard-card">
                    <div class="card-icon" style="background: #f39c12;">
                        <i class="fas fa-cog"></i>
                    </div>
                    <div class="card-content">
                        <h3>Settings</h3>
                        <p>Site Configuration</p>
                    </div>
                    <a href="settings.php" class="card-link">Manage</a>
                </div>
            </div>
            
            <div class="dashboard-actions">
                <a href="../index.php" class="btn btn-secondary" target="_blank">
                    <i class="fas fa-eye"></i> View Website
                </a>
            </div>
        </main>
    </div>
</body>
</html>