<?php
require_once '../config.php';
requireAdminLogin();

$conn = getDBConnection();
$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] == 'add' || $_POST['action'] == 'edit') {
        $title = $_POST['title'];
        $subtitle = $_POST['subtitle'];
        $image_url = $_POST['image_url'];
        $link_url = $_POST['link_url'];
        $display_order = $_POST['display_order'];
        $is_active = isset($_POST['is_active']) ? 1 : 0;
        
        if ($_POST['action'] == 'add') {
            $stmt = $conn->prepare("INSERT INTO banners (title, subtitle, image_url, link_url, display_order, is_active) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("ssssii", $title, $subtitle, $image_url, $link_url, $display_order, $is_active);
            $message = 'Banner added successfully!';
        } else {
            $id = $_POST['id'];
            $stmt = $conn->prepare("UPDATE banners SET title=?, subtitle=?, image_url=?, link_url=?, display_order=?, is_active=? WHERE id=?");
            $stmt->bind_param("ssssiii", $title, $subtitle, $image_url, $link_url, $display_order, $is_active, $id);
            $message = 'Banner updated successfully!';
        }
        $stmt->execute();
        $stmt->close();
    }
}

if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $conn->query("DELETE FROM banners WHERE id = $id");
    $message = 'Banner deleted successfully!';
}

$banners = $conn->query("SELECT * FROM banners ORDER BY display_order ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Banners - CarsDekho Admin</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="admin-container">
        <?php include 'includes/sidebar.php'; ?>
        
        <main class="admin-main">
            <div class="page-header">
                <h1>Manage Banners</h1>
                <button class="btn btn-primary" onclick="openModal()">
                    <i class="fas fa-plus"></i> Add Banner
                </button>
            </div>
            
            <?php if ($message): ?>
            <div class="alert alert-success"><?php echo $message; ?></div>
            <?php endif; ?>
            
            <div class="admin-table">
                <table>
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Subtitle</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($banner = $banners->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $banner['display_order']; ?></td>
                            <td><img src="<?php echo $banner['image_url']; ?>" class="table-image"></td>
                            <td><?php echo $banner['title']; ?></td>
                            <td><?php echo $banner['subtitle']; ?></td>
                            <td>
                                <span class="badge <?php echo $banner['is_active'] ? 'badge-success' : 'badge-danger'; ?>">
                                    <?php echo $banner['is_active'] ? 'Active' : 'Inactive'; ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info" onclick='editBanner(<?php echo json_encode($banner); ?>)'>
                                    <i class="fas fa-edit"></i>
                                </button>
                                <a href="?delete=<?php echo $banner['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
    
    <div id="bannerModal" class="modal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <h2 id="modalTitle">Add Banner</h2>
            <form method="POST" action="">
                <input type="hidden" name="action" id="formAction" value="add">
                <input type="hidden" name="id" id="bannerId">
                
                <div class="form-group">
                    <label>Title *</label>
                    <input type="text" name="title" id="title" required class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Subtitle</label>
                    <input type="text" name="subtitle" id="subtitle" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Image URL *</label>
                    <input type="url" name="image_url" id="image_url" required class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Link URL</label>
                    <input type="url" name="link_url" id="link_url" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>Display Order</label>
                    <input type="number" name="display_order" id="display_order" value="0" class="form-control">
                </div>
                
                <div class="form-group">
                    <label>
                        <input type="checkbox" name="is_active" id="is_active" checked>
                        Active
                    </label>
                </div>
                
                <button type="submit" class="btn btn-primary">Save</button>
                <button type="button" class="btn btn-secondary" onclick="closeModal()">Cancel</button>
            </form>
        </div>
    </div>
    
    <script>
        function openModal() {
            document.getElementById('bannerModal').style.display = 'block';
            document.getElementById('modalTitle').textContent = 'Add Banner';
            document.getElementById('formAction').value = 'add';
            document.querySelector('form').reset();
        }
        
        function closeModal() {
            document.getElementById('bannerModal').style.display = 'none';
        }
        
        function editBanner(banner) {
            document.getElementById('bannerModal').style.display = 'block';
            document.getElementById('modalTitle').textContent = 'Edit Banner';
            document.getElementById('formAction').value = 'edit';
            document.getElementById('bannerId').value = banner.id;
            document.getElementById('title').value = banner.title;
            document.getElementById('subtitle').value = banner.subtitle;
            document.getElementById('image_url').value = banner.image_url;
            document.getElementById('link_url').value = banner.link_url;
            document.getElementById('display_order').value = banner.display_order;
            document.getElementById('is_active').checked = banner.is_active == 1;
        }
    </script>
</body>
</html>
<?php $conn->close(); ?>