# Neutrinos Website Design Guidelines

## Design Approach
**Selected Approach:** Hybrid - Modern SaaS Design System with Enterprise Credibility

Drawing inspiration from Linear's typography precision, Stripe's restrained elegance, and Vercel's clean layouts while maintaining enterprise trustworthiness. This B2B platform requires professional sophistication balanced with modern web aesthetics.

**Key Design Principles:**
- Enterprise credibility through clean, structured layouts
- Data-driven storytelling with prominent metrics
- Professional color palette emphasizing trust and innovation
- Generous whitespace for clarity and focus

## Core Design Elements

### A. Color Palette

**Light Mode:**
- Primary Brand: 221 83% 53% (Deep professional blue)
- Primary Accent: 217 91% 60% (Vibrant blue for CTAs)
- Background: 0 0% 100% (Pure white)
- Surface: 220 13% 97% (Subtle gray for cards)
- Text Primary: 222 47% 11% (Near black)
- Text Secondary: 215 16% 47% (Muted blue-gray)
- Border: 214 32% 91% (Light border)
- Success Metrics: 142 76% 36% (Green for positive stats)

**Dark Mode:**
- Primary Brand: 221 83% 53%
- Background: 222 47% 11%
- Surface: 217 33% 17%
- Text Primary: 210 40% 98%
- Text Secondary: 215 20% 65%
- Border: 217 33% 24%

### B. Typography

**Font Families:**
- Primary: 'Inter' (via Google Fonts) - headings, body text
- Monospace: 'JetBrains Mono' (via Google Fonts) - code, metrics

**Type Scale:**
- Hero Headline: text-6xl md:text-7xl lg:text-8xl, font-bold, tracking-tight
- Section Headers: text-4xl md:text-5xl, font-bold, tracking-tight
- Subsection Headers: text-2xl md:text-3xl, font-semibold
- Body Large: text-lg md:text-xl, leading-relaxed
- Body: text-base, leading-relaxed
- Small/Captions: text-sm, text-secondary

### C. Layout System

**Spacing Primitives:** Tailwind units of 4, 8, 12, 16, 20, 24, 32 (p-4, m-8, gap-12, py-16, etc.)

**Container Structure:**
- Max width: max-w-7xl for main content
- Horizontal padding: px-4 md:px-8 lg:px-12
- Section vertical spacing: py-16 md:py-24 lg:py-32
- Component spacing: gap-8 md:gap-12 lg:gap-16

**Grid Patterns:**
- Client logos: grid-cols-3 md:grid-cols-4 lg:grid-cols-6
- Metrics: grid-cols-1 md:grid-cols-3
- Features: grid-cols-1 md:grid-cols-2 lg:grid-cols-3

### D. Component Library

**Header/Navigation:**
- Fixed header with backdrop blur (backdrop-blur-md bg-white/80)
- Logo on left, navigation center, CTA button right
- Navigation items with subtle hover states
- Mobile hamburger menu for responsive

**Hero Slider:**
- Full-width carousel with smooth transitions
- Three slides: Awards showcase, Business metrics dashboard, Workflow visualization
- Navigation dots below, subtle arrow controls
- Auto-advance with 5-second intervals

**Metrics Cards:**
- Large numerical display (text-5xl font-bold)
- Descriptive text below (text-lg text-secondary)
- Subtle gradient background or border accent
- Hover lift effect (hover:-translate-y-1)

**Client Logo Carousel:**
- Grayscale logos with opacity-70
- Hover: full color/opacity-100
- Infinite scroll animation
- Responsive grid fallback

**Feature Cards:**
- Icon or image at top (h-48 object-cover rounded-lg)
- Title (text-2xl font-semibold)
- Description (text-base text-secondary leading-relaxed)
- "Learn more" link with arrow
- Subtle border and hover shadow effect

**Why Neutrinos Section:**
- Two-column layout (image left, content right on desktop)
- Stacked list of capabilities with icons
- Platform framework diagram or visual
- Contrast background (bg-surface dark:bg-surface-dark)

**Resources Grid:**
- Card-based layout for articles/news
- Featured image (aspect-ratio-16/9)
- Category tag, title, excerpt, read time
- 3-column grid on desktop, stacked on mobile

**Footer:**
- Multi-column layout (Company, Platform, Resources, Legal)
- Social icons with hover states
- Newsletter signup form
- Copyright and compliance text

### E. Images

**Hero Slider Images:**
1. **Awards Image:** Professional awards ceremony or trophy showcase with overlay text
2. **Metrics Dashboard:** Clean dashboard UI showing 500+ professionals, 15+ countries, 25+ enterprise insurers, 120+ accelerators
3. **Workflow Diagram:** Clean flowchart/process visualization showing automation workflow

**Section Images:**
- Feature section: High-quality screenshots of platform UI
- Why Neutrinos: Platform architecture diagram or interface showcase
- Resources: Article thumbnail images (16:9 aspect ratio)

**Client Logos:** Use provided logos in grayscale, arranged in scrolling carousel

**Image Treatment:**
- Rounded corners (rounded-lg to rounded-xl)
- Subtle shadows for depth
- Maintain aspect ratios
- Optimize for performance

### F. Interactions & Animations

**Minimal Animation Strategy:**
- Slider transitions: smooth slide with fade (500ms duration)
- Hover states: subtle lift (-translate-y-1) and shadow increase
- Client logo carousel: smooth infinite scroll
- Scroll-triggered fade-ins for sections (intersection observer)
- Button/link hover: slight scale or color shift
- No parallax, no heavy animations

**Button States:**
- Primary CTA: solid background, hover brightness increase
- Secondary: outline with hover fill
- Disabled: reduced opacity
- Loading: spinner or pulse effect

## Key Layout Sections

1. **Header:** Sticky navigation with logo, menu, CTA
2. **Hero Slider:** 3-slide carousel with awards, metrics, workflow
3. **Customer Benefits Metrics:** 3-column grid with large numbers (95% accuracy, 70% cost reduction, 8x faster)
4. **Client Carousel:** Infinite scrolling logo parade
5. **Key Features:** 3-column grid (Accelerate, Integrate, Innovate) with images
6. **Why Neutrinos:** Two-column with platform framework details
7. **Resources:** 3-column article/news grid
8. **Footer:** Multi-column with links and newsletter signup

## Visual Hierarchy

- Hero slider dominates above fold (70vh height)
- Metrics use extra-large typography (text-6xl)
- Section headers clearly delineate content blocks
- Consistent card elevation for related content
- White/negative space separates major sections
- Color used sparingly for emphasis (CTAs, metrics)