import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { ArrowRight, Calendar } from "lucide-react";

const resources = [
  {
    category: "Press Release",
    title: "Neutrinos Wins Globee Award for Enterprise AI-driven Automation Innovation",
    excerpt: "Recognized for excellence in driving digital transformation in the insurance industry through innovative AI-powered automation solutions.",
    date: "October 2025",
  },
  {
    category: "Case Study",
    title: "American Public Life (APL) Selects Neutrinos to Power Core Modernization",
    excerpt: "APL leverages Neutrinos to provide a 10x better customer service experience, delivering speed, accuracy, and connectivity.",
    date: "September 2025",
  },
  {
    category: "Whitepaper",
    title: "The Future of Insurance Automation: AI-Native Platforms",
    excerpt: "Discover how AI-native automation platforms are transforming the insurance value chain from underwriting to claims processing.",
    date: "August 2025",
  },
];

export default function ResourcesSection() {
  return (
    <section className="py-16 md:py-24 bg-card">
      <div className="container mx-auto px-4 md:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl lg:text-5xl font-bold tracking-tight mb-4">
            Latest Resources
          </h2>
          <p className="text-lg md:text-xl text-muted-foreground max-w-3xl mx-auto">
            Stay updated with the latest news, insights, and innovations from Neutrinos
          </p>
        </div>

        <div className="grid md:grid-cols-3 gap-8">
          {resources.map((resource, index) => (
            <Card key={index} className="hover-elevate" data-testid={`card-resource-${index}`}>
              <CardContent className="p-6 space-y-4">
                <Badge variant="secondary" data-testid={`badge-category-${index}`}>
                  {resource.category}
                </Badge>
                <h3 className="text-xl font-semibold leading-tight">{resource.title}</h3>
                <p className="text-muted-foreground leading-relaxed">{resource.excerpt}</p>
                <div className="flex items-center gap-2 text-sm text-muted-foreground">
                  <Calendar className="h-4 w-4" />
                  <span data-testid={`text-date-${index}`}>{resource.date}</span>
                </div>
                <Button variant="ghost" className="gap-2 px-0" data-testid={`button-read-${index}`}>
                  Read more <ArrowRight className="h-4 w-4" />
                </Button>
              </CardContent>
            </Card>
          ))}
        </div>

        <div className="text-center mt-12">
          <Button size="lg" variant="outline" data-testid="button-view-all">
            View All Resources
          </Button>
        </div>
      </div>
    </section>
  );
}
