import { Button } from "@/components/ui/button";
import { ChevronLeft, ChevronRight } from "lucide-react";
import { useState, useEffect } from "react";
import awardsImg from "@assets/unnamed (1)_1760685495562.png";
import benefitsImg from "@assets/8c063b02-a70c-4b7e-b5bf-ac4c36143b07.png";
import workflowImg from "@assets/unnamed (3)_1760685495561.png";

const slides = [
  {
    image: awardsImg,
    title: "Neutrinos Wins Globee Award for Enterprise AI-driven Automation Innovation",
    subtitle: "Recognized for excellence in insurance technology",
    type: "award"
  },
  {
    image: benefitsImg,
    title: "Trusted by Industry Leaders Worldwide",
    subtitle: "95% accuracy in document extraction | 70% reduction in manual processing costs | 8x reduction in processing time",
    type: "metrics"
  },
  {
    image: workflowImg,
    title: "The Neutrinos Library Framework",
    subtitle: "Intelligent automation powered by predictive analysis and business-specific knowledge",
    type: "workflow"
  }
];

export default function HeroSlider() {
  const [currentSlide, setCurrentSlide] = useState(0);

  useEffect(() => {
    const timer = setInterval(() => {
      setCurrentSlide((prev) => (prev + 1) % slides.length);
    }, 5000);
    return () => clearInterval(timer);
  }, []);

  const goToSlide = (index: number) => {
    setCurrentSlide(index);
  };

  const nextSlide = () => {
    setCurrentSlide((prev) => (prev + 1) % slides.length);
  };

  const prevSlide = () => {
    setCurrentSlide((prev) => (prev - 1 + slides.length) % slides.length);
  };

  return (
    <div className="relative w-full h-[70vh] min-h-[500px] bg-gradient-to-br from-primary/5 to-background overflow-hidden">
      {slides.map((slide, index) => (
        <div
          key={index}
          className={`absolute inset-0 transition-opacity duration-500 ${
            index === currentSlide ? "opacity-100" : "opacity-0"
          }`}
        >
          <div className="container mx-auto px-4 md:px-8 h-full flex items-center">
            <div className="grid md:grid-cols-2 gap-8 md:gap-12 items-center w-full">
              <div className="space-y-6">
                <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold tracking-tight">
                  {slide.title}
                </h1>
                <p className="text-lg md:text-xl text-muted-foreground leading-relaxed">
                  {slide.subtitle}
                </p>
                <div className="flex gap-4">
                  <Button size="lg" data-testid="button-hero-cta">
                    Get Started
                  </Button>
                  <Button size="lg" variant="outline" data-testid="button-hero-learn">
                    Learn More
                  </Button>
                </div>
              </div>
              <div className="relative h-[300px] md:h-[400px]">
                <img
                  src={slide.image}
                  alt={slide.title}
                  className="w-full h-full object-contain rounded-lg"
                  data-testid={`img-slide-${slide.type}`}
                />
              </div>
            </div>
          </div>
        </div>
      ))}

      {/* <Button
        variant="ghost"
        size="icon"
        className="absolute left-4 top-1/2 -translate-y-1/2 bg-background/80 backdrop-blur-sm"
        onClick={prevSlide}
        data-testid="button-slide-prev"
      >
        <ChevronLeft className="h-6 w-6" />
      </Button>

      <Button
        variant="ghost"
        size="icon"
        className="absolute right-4 top-1/2 -translate-y-1/2 bg-background/80 backdrop-blur-sm"
        onClick={nextSlide}
        data-testid="button-slide-next"
      >
        <ChevronRight className="h-6 w-6" />
      </Button> */}

      <div className="absolute bottom-8 left-1/2 -translate-x-1/2 flex gap-2">
        {slides.map((_, index) => (
          <button
            key={index}
            className={`w-2 h-2 rounded-full transition-all ${
              index === currentSlide ? "bg-primary w-8" : "bg-primary/30"
            }`}
            onClick={() => goToSlide(index)}
            data-testid={`button-dot-${index}`}
          />
        ))}
      </div>
    </div>
  );
}
