import React from "react";

// Import all 15 client logos
import logo1 from "@assets/0ae5f7.webp";
import logo2 from "@assets/9a869d.webp";
import logo3 from "@assets/22d808.webp";
import logo4 from "@assets/51a75c.webp";
import logo5 from "@assets/70adb9.webp";
import logo6 from "@assets/173c6c.webp";
import logo7 from "@assets/367bb8.webp";
import logo8 from "@assets/4000d7.webp";
import logo9 from "@assets/5462e3.webp";
import logo10 from "@assets/279799.webp";
import logo11 from "@assets/ae4ef1.webp";
import logo12 from "@assets/c67314.webp";
import logo13 from "@assets/dddf7e.webp";
import logo14 from "@assets/f7213b.webp";
import logo15 from "@assets/ff5342.webp";

const logos = [
  logo1,
  logo2,
  logo3,
  logo4,
  logo5,
  logo6,
  logo7,
  logo8,
  logo9,
  logo10,
  logo11,
  logo12,
  logo13,
  logo14,
  logo15,
];

export default function ClientCarousel() {
  return (
    <section className="py-10 bg-white">
      <div className="container mx-auto px-4 md:px-8">
        {/* <h2 className="text-center text-2xl md:text-3xl font-semibold mb-8 text-gray-800">
          Trusted by Leading Clients
        </h2> */}

        <div className="overflow-hidden relative">
          <div className="flex animate-scroll gap-12 justify-center items-center">
            {/* duplicate logos for seamless infinite effect */}
            {[...logos, ...logos].map((logo, index) => (
              <img
                key={index}
                src={logo}
                alt={`Client Logo ${index + 1}`}
                className="h-12 md:h-16 w-auto object-contain grayscale hover:grayscale-0 transition duration-300"
              />
            ))}
          </div>
        </div>
      </div>
    </section>
  );
}
